/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.ponder.scenes.trains;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.trains.station.StationBlock;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import net.createmod.catnip.math.Pointing;
import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.element.ParrotElement;
import net.createmod.ponder.api.element.ParrotPose;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.createmod.ponder.api.scene.Selection;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2769;

public class TrainScenes {
    public static void controls(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("train_controls", "Controlling Trains");
        scene.configureBasePlate(1, 0, 9);
        scene.scaleSceneView(0.75f);
        scene.setSceneOffsetY(-1.0f);
        scene.showBasePlate();
        for (int i = 10; i >= 0; --i) {
            scene.world().showSection(util.select().position(i, 1, 4), class_2350.field_11033);
            scene.idle(1);
        }
        class_2338 stationPos = util.grid().at(4, 1, 1);
        Selection station = util.select().position(stationPos);
        Selection whistle = util.select().fromTo(4, 3, 4, 4, 4, 4);
        Selection train = util.select().fromTo(5, 2, 3, 1, 3, 5).substract(whistle);
        scene.world().showSection(station, class_2350.field_11033);
        scene.idle(20);
        ElementLink trainElement = scene.world().showIndependentSection(train, class_2350.field_11033);
        scene.world().cycleBlockProperty(stationPos, (class_2769)StationBlock.ASSEMBLING);
        scene.idle(15);
        class_2338 initialControlsPos = util.grid().at(3, 3, 4);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.WHITE, (Object)train, new class_238(initialControlsPos).method_1002(-0.375, 0.125, 0.0), 85);
        scene.idle(15);
        scene.overlay().showText(70).pointAt(util.vector().of((double)3.35f, 3.75, 5.0)).placeNearTarget().attachKeyFrame().text("Train Controls are required on every train contraption");
        scene.idle(60);
        scene.world().cycleBlockProperty(stationPos, (class_2769)StationBlock.ASSEMBLING);
        scene.effects().indicateSuccess(stationPos);
        scene.world().animateTrainStation(stationPos, true);
        scene.world().toggleControls(initialControlsPos);
        scene.idle(20);
        scene.overlay().showControls(util.vector().topOf(initialControlsPos), Pointing.DOWN, 70).rightClick();
        scene.idle(20);
        scene.overlay().showText(60).pointAt(util.vector().of((double)3.35f, 3.75, 5.0)).placeNearTarget().attachKeyFrame().text("Once assembled, right-click the block to start driving");
        scene.idle(60);
        scene.world().moveSection(trainElement, util.vector().of(4.0, 0.0, 0.0), 20);
        scene.world().animateBogey(util.grid().at(3, 2, 4), -4.0f, 20);
        scene.world().animateTrainStation(stationPos, false);
        scene.idle(30);
        scene.overlay().showText(60).pointAt(util.vector().of((double)7.35f, 3.75, 5.0)).placeNearTarget().text("Accelerate and steer the Train using movement keybinds");
        scene.idle(60);
        scene.world().moveSection(trainElement, util.vector().of(-4.0, 0.0, 0.0), 30);
        scene.world().animateBogey(util.grid().at(3, 2, 4), 4.0f, 30);
        scene.idle(40);
        scene.overlay().showControls(util.vector().topOf(initialControlsPos), Pointing.DOWN, 70).scroll();
        scene.idle(20);
        scene.overlay().showText(90).pointAt(util.vector().of((double)3.35f, 3.75, 5.0)).placeNearTarget().text("If desired, the top speed can be fine-tuned using the mouse wheel");
        scene.idle(90);
        scene.world().moveSection(trainElement, util.vector().of(2.0, 0.0, 0.0), 30);
        scene.world().animateBogey(util.grid().at(3, 2, 4), -2.0f, 30);
        scene.idle(40);
        scene.world().moveSection(trainElement, util.vector().of(-3.0, 0.0, 0.0), 60);
        scene.world().animateBogey(util.grid().at(3, 2, 4), 3.0f, 60);
        scene.idle(70);
        scene.overlay().showText(50).pointAt(util.vector().of((double)2.35f, 3.75, 5.0)).placeNearTarget().attachKeyFrame().text("Hold space to approach a nearby Station");
        scene.idle(40);
        scene.world().moveSection(trainElement, util.vector().of(1.0, 0.0, 0.0), 20);
        scene.world().animateBogey(util.grid().at(3, 2, 4), -1.0f, 20);
        scene.idle(20);
        scene.effects().indicateSuccess(stationPos);
        scene.world().animateTrainStation(stationPos, true);
        scene.idle(10);
        scene.overlay().showText(80).pointAt(util.vector().topOf(stationPos)).placeNearTarget().text("Trains can only be disassembled back into blocks at Stations");
        scene.idle(40);
        scene.world().cycleBlockProperty(stationPos, (class_2769)StationBlock.ASSEMBLING);
        scene.world().toggleControls(initialControlsPos);
        scene.idle(20);
        scene.world().showSectionAndMerge(whistle, class_2350.field_11033, trainElement);
        scene.idle(20);
        scene.world().cycleBlockProperty(stationPos, (class_2769)StationBlock.ASSEMBLING);
        scene.effects().indicateSuccess(stationPos);
        scene.world().toggleControls(initialControlsPos);
        scene.idle(20);
        scene.overlay().showText(70).pointAt(util.vector().of((double)4.95f, 3.75, 5.0)).placeNearTarget().attachKeyFrame().text("Assembled Whistles can be activated with the sprint key");
        scene.idle(40);
        scene.world().toggleRedstonePower(whistle);
        scene.idle(20);
        scene.world().toggleRedstonePower(whistle);
        scene.idle(20);
        scene.overlay().showText(70).pointAt(util.vector().of((double)3.35f, 3.75, 5.0)).placeNearTarget().attachKeyFrame().text("Sneak or click again to stop controlling the Train");
        scene.idle(60);
    }

    public static void schedule(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("train_schedule", "Using Train Schedules");
        scene.configureBasePlate(1, 0, 9);
        scene.scaleSceneView(0.75f);
        scene.setSceneOffsetY(-1.0f);
        scene.showBasePlate();
        scene.world().cycleBlockProperty(util.grid().at(3, 3, 4), (class_2769)BlazeBurnerBlock.HEAT_LEVEL);
        for (int i = 10; i >= 0; --i) {
            scene.world().showSection(util.select().position(i, 1, 4), class_2350.field_11033);
            scene.idle(1);
        }
        scene.world().toggleControls(util.grid().at(4, 3, 4));
        scene.world().toggleControls(util.grid().at(4, 3, 7));
        class_2338 stationPos = util.grid().at(5, 1, 1);
        Selection train1 = util.select().fromTo(6, 2, 3, 2, 3, 5);
        Selection train2 = util.select().fromTo(6, 2, 6, 2, 3, 8);
        scene.idle(10);
        scene.world().showSection(util.select().position(stationPos), class_2350.field_11033);
        scene.idle(5);
        ElementLink trainElement1 = scene.world().showIndependentSection(train1, class_2350.field_11033);
        scene.idle(10);
        scene.world().animateTrainStation(stationPos, true);
        scene.idle(10);
        scene.overlay().showText(70).pointAt(util.vector().blockSurface(util.grid().at(3, 3, 4), class_2350.field_11039)).placeNearTarget().attachKeyFrame().text("Schedules allow Trains to be controlled by other Drivers");
        scene.idle(80);
        class_243 target = util.vector().topOf(util.grid().at(4, 0, 2));
        scene.overlay().showControls(target, Pointing.RIGHT, 80).rightClick().withItem(AllItems.SCHEDULE.asStack());
        scene.overlay().showText(80).pointAt(target).placeNearTarget().attachKeyFrame().colored(PonderPalette.BLUE).text("Right-click with the item in hand to open its Interface");
        scene.idle(100);
        scene.overlay().showControls(util.vector().topOf(util.grid().at(3, 3, 4)), Pointing.DOWN, 80).rightClick().withItem(AllItems.SCHEDULE.asStack());
        scene.idle(6);
        scene.world().conductorBlaze(util.grid().at(3, 3, 4), true);
        scene.overlay().showText(70).pointAt(util.vector().blockSurface(util.grid().at(3, 3, 4), class_2350.field_11039)).placeNearTarget().attachKeyFrame().text("Once programmed, the Schedule can be handed off to a Train Driver");
        scene.idle(80);
        scene.world().moveSection(trainElement1, util.vector().of(12.0, 0.0, 0.0), 60);
        scene.world().animateBogey(util.grid().at(4, 2, 4), -12.0f, 60);
        scene.world().animateTrainStation(stationPos, false);
        scene.idle(20);
        scene.world().hideIndependentSection(trainElement1, null);
        scene.idle(25);
        ElementLink trainElement2 = scene.world().showIndependentSection(train2, class_2350.field_11033);
        scene.world().moveSection(trainElement2, util.vector().of(0.0, 0.0, -3.0), 0);
        scene.idle(10);
        class_243 birbVec = util.vector().topOf(util.grid().at(3, 0, 7));
        ElementLink<ParrotElement> birb = scene.special().createBirb(birbVec, ParrotPose.FacePointOfInterestPose::new);
        scene.world().animateTrainStation(stationPos, true);
        scene.overlay().showText(110).pointAt(birbVec).placeNearTarget().attachKeyFrame().text("Any mob or blaze burner sitting in front of Train Controls is an eligible conductor");
        scene.idle(80);
        scene.overlay().showControls(util.vector().centerOf(util.grid().at(3, 1, 7)), Pointing.DOWN, 30).withItem(new class_1799((class_1935)class_1802.field_8719));
        scene.idle(40);
        target = util.vector().centerOf(util.grid().at(3, 3, 4));
        scene.overlay().showControls(target.method_1031(0.5, 0.0, 0.0), Pointing.RIGHT, 30).rightClick().withItem(new class_1799((class_1935)class_1802.field_8719));
        scene.idle(6);
        scene.special().moveParrot(birb, target.method_1020(birbVec), 5);
        scene.effects().indicateSuccess(util.grid().at(3, 3, 4));
        scene.idle(15);
        scene.overlay().showText(70).pointAt(target).placeNearTarget().colored(PonderPalette.BLUE).attachKeyFrame().text("Creatures on a lead can be given their seat more conveniently");
        scene.idle(80);
        scene.overlay().showControls(util.vector().topOf(util.grid().at(3, 3, 4)), Pointing.DOWN, 15).withItem(AllItems.SCHEDULE.asStack());
        scene.idle(6);
        scene.special().conductorBirb(birb, true);
        scene.special().movePointOfInterest(util.grid().at(16, 4, 4));
        scene.idle(14);
        scene.world().moveSection(trainElement2, util.vector().of(3.0, 0.0, 0.0), 30);
        scene.world().animateBogey(util.grid().at(4, 2, 7), -3.0f, 30);
        scene.special().moveParrot(birb, util.vector().of(3.0, 0.0, 0.0), 30);
        scene.idle(40);
        scene.overlay().showControls(util.vector().topOf(util.grid().at(6, 3, 4)), Pointing.DOWN, 70).rightClick();
        scene.idle(6);
        scene.special().conductorBirb(birb, false);
        scene.special().movePointOfInterest(util.grid().at(3, 4, 1));
        scene.idle(19);
        scene.overlay().showText(70).pointAt(target.method_1031(3.0, 0.0, 0.0)).placeNearTarget().colored(PonderPalette.BLUE).attachKeyFrame().text("Schedules can be retrieved from Drivers at any moment");
        scene.idle(80);
    }
}

